/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends PDFTextStripper {
    private boolean inParagraph = false;
    private final XHTMLContentHandler handler;
    private final boolean extractAnnotationText;

    public static void process(PDDocument document, ContentHandler handler, Metadata metadata, boolean extractAnnotationText, boolean enableAutoSpace, boolean suppressDuplicateOverlappingText, boolean sortByPosition) throws SAXException, TikaException {
        try {
            new PDF2XHTML(handler, metadata, extractAnnotationText, enableAutoSpace, suppressDuplicateOverlappingText, sortByPosition).writeText(document, new Writer(){

                public void write(char[] cbuf, int off, int len) {
                }

                public void flush() {
                }

                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
    }

    private PDF2XHTML(ContentHandler handler, Metadata metadata, boolean extractAnnotationText, boolean enableAutoSpace, boolean suppressDuplicateOverlappingText, boolean sortByPosition) throws IOException {
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.extractAnnotationText = extractAnnotationText;
        this.setForceParsing(true);
        this.setSortByPosition(sortByPosition);
        if (enableAutoSpace) {
            this.setWordSeparator(" ");
        } else {
            this.setWordSeparator("");
        }
        this.setSuppressDuplicateOverlappingText(suppressDuplicateOverlappingText);
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", e);
        }
        this.writeParagraphStart();
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            if (this.extractAnnotationText) {
                for (Object o : page.getAnnotations()) {
                    PDActionURI uri;
                    String link;
                    PDAction action;
                    PDAnnotationLink annotationlink;
                    if (o instanceof PDAnnotationLink && (annotationlink = (PDAnnotationLink)o).getAction() != null && (action = annotationlink.getAction()) instanceof PDActionURI && (link = (uri = (PDActionURI)action).getURI()) != null) {
                        this.handler.startElement("div", "class", "annotation");
                        this.handler.startElement("a", "href", link);
                        this.handler.endElement("a");
                        this.handler.endElement("div");
                    }
                    if (!(o instanceof PDAnnotation) || !"FreeText".equals(((PDAnnotation)o).getSubtype())) continue;
                    PDAnnotationMarkup annot = (PDAnnotationMarkup)o;
                    String title = annot.getTitlePopup();
                    String subject = annot.getTitlePopup();
                    String contents = annot.getContents();
                    if (title == null && subject == null && contents == null) continue;
                    this.handler.startElement("div", "class", "annotation");
                    if (title != null) {
                        this.handler.startElement("div", "class", "annotationTitle");
                        this.handler.characters(title);
                        this.handler.endElement("div");
                    }
                    if (subject != null) {
                        this.handler.startElement("div", "class", "annotationSubject");
                        this.handler.characters(subject);
                        this.handler.endElement("div");
                    }
                    if (contents != null) {
                        this.handler.startElement("div", "class", "annotationContents");
                        this.handler.characters(contents);
                        this.handler.endElement("div");
                    }
                    this.handler.endElement("div");
                }
            }
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", e);
        }
    }

    protected void writeParagraphStart() throws IOException {
        if (this.inParagraph) {
            this.writeParagraphEnd();
        }
        assert (!this.inParagraph);
        this.inParagraph = true;
        try {
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", e);
        }
    }

    protected void writeParagraphEnd() throws IOException {
        if (!this.inParagraph) {
            this.writeParagraphStart();
        }
        assert (this.inParagraph);
        this.inParagraph = false;
        try {
            this.handler.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.handler.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.handler.characters("\n");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", e);
        }
    }
}

