/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pkcs7Parser
extends AbstractParser {
    private static final long serialVersionUID = -7310531559075115044L;
    private static final MediaType PKCS7_MIME = MediaType.application("pkcs7-mime");
    private static final MediaType PKCS7_SIGNATURE = MediaType.application("pkcs7-signature");

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return MediaType.set(PKCS7_MIME, PKCS7_SIGNATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try {
            CMSSignedDataParser parser = new CMSSignedDataParser(new CloseShieldInputStream(stream));
            try {
                CMSTypedStream content = parser.getSignedContent();
                InputStream input = content.getContentStream();
                try {
                    Parser delegate = context.get(Parser.class, EmptyParser.INSTANCE);
                    delegate.parse(input, handler, metadata, context);
                }
                finally {
                    input.close();
                }
            }
            finally {
                parser.close();
            }
        }
        catch (CMSException e) {
            throw new TikaException("Unable to parse pkcs7 signed data", e);
        }
    }
}

